// XISLDialogDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "ib.h"
#include "XISLDialogDlg.h"
#include "XISLDialogTag.h"
#include "XISLVar.h"
#include "XISLVarList.h"
#include "MainFrm.h"
#include "IBFlowview.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CXISLDialogDlg _CAO
CXISLDialogDlg::CXISLDialogDlg(CXISLDialogTag *pTag,CIBFlowView *pView,CWnd* pParent /*=NULL*/)
	: CDialog(CXISLDialogDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CXISLDialogDlg)
	m_nScope = -1;
	m_nRadioGlp = -1;
	m_nRepeat = 0;
	m_strID = _T("");
	m_strVarAnnotation = _T("");
	m_strVarName = _T("");
	//}}AFX_DATA_INIT
	m_pParentView = pView;
	m_pDialogTag = pTag;
	m_bModifiedFlag = FALSE;
}


void CXISLDialogDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CXISLDialogDlg)
	DDX_Control(pDX, IDC_LIST_VAR, m_lstCtrlVar);
	DDX_Control(pDX, IDC_DLGSCOPE_COMBO, m_ScopeCombo);
	DDX_CBIndex(pDX, IDC_DLGSCOPE_COMBO, m_nScope);
	DDX_Radio(pDX, IDC_DLGSEQ_RADIO, m_nRadioGlp);
	DDX_Text(pDX, IDC_DLGREPEAT_EDIT, m_nRepeat);
	DDV_MinMaxInt(pDX, m_nRepeat, 0, 999);
	DDX_Text(pDX, IDC_ID_EDIT, m_strID);
	DDX_Text(pDX, IDC_EDIT_VARANNO, m_strVarAnnotation);
	DDX_Text(pDX, IDC_EDIT_VARNAME, m_strVarName);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CXISLDialogDlg, CDialog)
	//{{AFX_MSG_MAP(CXISLDialogDlg)
	ON_CBN_SELCHANGE(IDC_DLGSCOPE_COMBO, OnSelchangeDlgscopeCombo)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST_VAR, OnKeydownListVar)
	ON_NOTIFY(LVN_ENDLABELEDIT, IDC_LIST_VAR, OnEndlabeleditListVar)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CXISLDialogDlg bZ[W nh

BOOL CXISLDialogDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_lstCtrlVar.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	LVCOLUMNA column;
	column.mask = LVCF_TEXT|LVCF_WIDTH;

	RECT rect;
	m_lstCtrlVar.GetClientRect(&rect);
	column.cx = 95;
	column.pszText = "ϐ";
	m_lstCtrlVar.InsertColumn(0,&column);

	column.cx = (rect.right - rect.left)-95;
	column.pszText = "";
	m_lstCtrlVar.InsertColumn(1,&column);
	
	m_strID = m_pDialogTag->GetDialogID();
	m_nScope = m_pDialogTag->GetDialogScope();
	//XR[vDocumentȂΈ͕VbgAEg(2003/4/22)
	if(m_nScope == ID_DIASCOPE_DOCUMENT)
	{
		GetDlgItem(IDC_EDIT_VARANNO)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_VARNAME)->EnableWindow(FALSE);
//		GetDlgItem(IDC_BUTTON_VAROK)->EnableWindow(FALSE);
		GetDlgItem(IDC_LIST_VAR)->EnableWindow(FALSE);
	}
	m_nRepeat = m_pDialogTag->GetDialogRepeat();
	m_nRadioGlp = m_pDialogTag->GetDialogComb();
	m_pDialogTag->SetArgVarList2LBox(m_lstCtrlVar);

	UpdateData(FALSE);
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

//OK{^ꂽƂ̏
void CXISLDialogDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();
	if(m_strID.IsEmpty())
	{
		AfxMessageBox("Dialog ID͕K{ł",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		return;
	}
	//Dialog^Ȏlݒ肷
	if(m_pDialogTag->SetDialogAttribute(m_strID,m_nRadioGlp,m_nRepeat,m_nScope))
		return;

	if(m_bModifiedFlag && !m_pDialogTag->m_ReCallList.IsEmpty())
	{
		AfxMessageBox("Ăяołcall,gotöύXĂD",
			MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
		CString strDocName;
		CMainFrame *pFrame = (CMainFrame*)AfxGetMainWnd();
		for(int i=0; i<m_pDialogTag->m_ReCallList.GetCount(); i++)
		{
			//Xg擪̃^O擾
			CXISLTag *pTag = (CXISLTag*)m_pDialogTag->m_ReCallList.GetHead();
			//擾^Oe_CAO^O擾
			CXISLDialogTag *pDTag = (CXISLDialogTag*)pTag->GetParentDialogTag();
			//^Cg̎擾
			strDocName = pDTag->GetDocName();
//			strDocName.Delete(strDocName.GetLength()-5,5);
			//^Cggq.xisl폜̂Rs[ 2003/4/??@ǉ
			CString strDocNameNoXisl = strDocName.SpanExcluding(".xisl");
			//w肳ꂽ^Cg̃EBhEANeBuɂ
			CIBFlowView *pView = pFrame->SetActiveWnd(strDocNameNoXisl,pTag->m_pParentTag);
			//Call^Õp[^ύX
			pView->ChangeCallParam((CXISLCallTag*)pTag);
		}
		strDocName = m_pDialogTag->GetDocName();
//		strDocName.Delete(strDocName.GetLength()-5,5);
		pFrame->SetActiveWnd(strDocName,m_pDialogTag);
	}
	if(m_nScope == ID_DIASCOPE_DOCUMENT)
	{
		if(m_pDialogTag->ResetArgVar())
			return;
	}

	CDialog::OnOK();
}

//XR[vDocumentȂ̐ݒsADialogȂݒ\ɂ
void CXISLDialogDlg::OnSelchangeDlgscopeCombo() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	UpdateData();
	if(m_nScope == ID_DIASCOPE_DOCUMENT)
	{//Document
		GetDlgItem(IDC_EDIT_VARANNO)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_VARNAME)->EnableWindow(FALSE);
//		GetDlgItem(IDC_BUTTON_VAROK)->EnableWindow(FALSE);
		GetDlgItem(IDC_LIST_VAR)->EnableWindow(FALSE);
	}
	else
	{//Dialog
		GetDlgItem(IDC_EDIT_VARANNO)->EnableWindow();
		GetDlgItem(IDC_EDIT_VARNAME)->EnableWindow();
//		GetDlgItem(IDC_BUTTON_VAROK)->EnableWindow();
		GetDlgItem(IDC_LIST_VAR)->EnableWindow();
	}
}

//^[L[ꂽƂ̏s
//A{IɈ͕ȊOŃ^[ꂽƂ͖悤ɂȂĂ
BOOL CXISLDialogDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
		CWnd *pWnd = GetFocus();
		CString strTemp;
		CXISLVar *pVar=NULL;
        switch( pMsg->wParam )
        {
        case VK_RETURN:   // Enter
			UpdateData();
			//擾Rg[ID͐()̏ꍇ
			if(pWnd->GetDlgCtrlID() == IDC_EDIT_VARNAME
				|| pWnd->GetDlgCtrlID() == IDC_EDIT_VARANNO)
			{
				if(m_strVarName.IsEmpty())
				{
					AfxMessageBox("ϐ͂Ă",
						MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				}
				pVar = new CXISLVar;
				//\̂ɐݒ
				if(pVar->SetAttribute(m_strVarName,m_strVarAnnotation,FALSE,FALSE) != 0)
				{
					delete pVar;
					return TRUE;
				}
				//̓o^
				if(m_pDialogTag->RegistDialogArg(pVar) != 0)
				{
					delete pVar;
					return TRUE;
				}
				pVar->ReferCount(TRUE);
				//Xgr[ɕ\
				m_pDialogTag->SetArgVarList2LBox(m_lstCtrlVar);
				m_strVarName.Empty();
				m_strVarAnnotation.Empty();
				m_bModifiedFlag = TRUE;
			}
			UpdateData(FALSE);
			return TRUE;
		default:
			break;
        }
	}
	return CDialog::PreTranslateMessage(pMsg);
}

//XgňIDELETE{^ꂽ炻̈폜
void CXISLDialogDlg::OnKeydownListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	//DELETE{^ꂽ
	if(pLVKeyDow->wVKey == VK_DELETE)
	{
		//XgACe̒擾
		int nIndex = m_lstCtrlVar.GetNextItem(-1,LVNI_SELECTED);
		//łACeꍇ
		if(nIndex != -1)
		{
			_TCHAR szBuff[MAX_PATH];
			LVITEMA item;
			item.mask = LVIF_TEXT|LVIF_PARAM|LVIF_STATE;
			item.iItem = nIndex;
			item.iSubItem = 0;
			item.pszText = szBuff;
			item.cchTextMax = sizeof(szBuff);
			item.stateMask = 0xFFFF;
			//IꂽACe̎擾
			m_lstCtrlVar.GetItem(&item);
			//IꂽACe݂ꍇ
			if(item.iItem != -1)
			{
				CXISLVar *pVar = (CXISLVar*)item.lParam;
				pVar->ReferCount(FALSE);
				//ACe̍폜s
				if(m_pDialogTag->RemoveDialogArg(pVar) == 0)
				{
					delete pVar;
					m_bModifiedFlag = TRUE;
					m_pDialogTag->SetArgVarList2LBox(m_lstCtrlVar);
				}
			}
		}
	}

	*pResult = 0;
}

//Xgr[̃ACeNbNĈύXƂ̏
void CXISLDialogDlg::OnEndlabeleditListVar(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_DISPINFO* pDispInfo = (LV_DISPINFO*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	if(pDispInfo->item.pszText)
	{
		*pResult = 1;
		CXISLVar *pVar = (CXISLVar*)pDispInfo->item.lParam;
		if(pVar->m_pParent->FindVar(pDispInfo->item.pszText) == NULL)
		{
			if(pVar->SetAttribute(pDispInfo->item.pszText,pVar->GetVarExpr(),FALSE,FALSE))
			{
				*pResult = 0;
			}
		}
		else
		{
			AfxMessageBox("̕ϐ͊ɓo^ς݂łD",
				MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
			*pResult = 0;
		}
		m_pDialogTag->SetArgVarList2LBox(m_lstCtrlVar);
		UpdateData(FALSE);
	}
	else
		*pResult = 0;
}
